function new_gridplot(x_ref_T,y_ref_T,X_V_rot,Y_V_rot,X_T,Y_T,x_ref_V_rot,y_ref_V_rot,VX_V_rot,VY_V_rot,xf_V_rot,yf_V_rot,X_Vx_T,Y_Vy_T,VX_T,VY_T,T)

    figure(1); clf, colormap(jet)
    
    % Modify the X Y units (from meters to km)
    x_ref_T = x_ref_T.*1e-3;
    y_ref_T = y_ref_T.*1e-3;
    X_V_rot = X_V_rot.*1e-3;
    Y_V_rot = Y_V_rot.*1e-3;
    X_T = X_T.*1e-3;
    Y_T = Y_T.*1e-3;
    X_Vx_T = X_Vx_T.*1e-3;
    Y_Vy_T = Y_Vy_T.*1e-3;
    xf_V_rot = xf_V_rot.*1e-3;
    yf_V_rot = yf_V_rot.*1e-3;
    x_ref_V_rot = x_ref_V_rot.*1e-3;
    y_ref_V_rot = y_ref_V_rot.*1e-3;
    
    hold on
    
%==========================================================================
    % PLOT T (initial Temp)
    pcolor(X_T,Y_T,T-273.15)
    shading interp
    set(get(colorbar,'label'),'string','Temperature [°C]');
    title({'Initial Temperature distribution'})
%==========================================================================

    % grid
    sp_g = 4;
    plot(X_V_rot(1:sp_g:end,1:sp_g:end),Y_V_rot(1:sp_g:end,1:sp_g:end),'b',X_V_rot(1:sp_g:end,1:sp_g:end)',Y_V_rot(1:sp_g:end,1:sp_g:end)','b','LineStyle',':')
    plot(X_T(1:sp_g:end,1:sp_g:end),Y_T(1:sp_g:end,1:sp_g:end),'r',X_T(1:sp_g:end,1:sp_g:end)',Y_T(1:sp_g:end,1:sp_g:end)','r','LineStyle',':')
    % reference point
    plot(x_ref_V_rot,y_ref_V_rot,'db', 'MarkerSize',5,'LineWidth',1)
    plot(x_ref_T,y_ref_T,'or', 'MarkerSize',5,'LineWidth',1)
    % fault
    plot(xf_V_rot,yf_V_rot,'k','LineWidth',2)
    % velocities
    sp_q_V = 8;
    quiver(X_V_rot(1:sp_q_V:end,1:sp_q_V:end),Y_V_rot(1:sp_q_V:end,1:sp_q_V:end),VX_V_rot(1:sp_q_V:end,1:sp_q_V:end),VY_V_rot(1:sp_q_V:end,1:sp_q_V:end),0.3,'b','LineWidth',0.3)
    sp_q_T = 6;
    quiver(X_Vx_T(1:sp_q_T:end-1,1:sp_q_T:end),Y_Vy_T(1:sp_q_T:end,1:sp_q_T:end-1),VX_T(1:sp_q_T:end-1,1:sp_q_T:end),VY_T(1:sp_q_T:end,1:sp_q_T:end-1),0.3,'r','LineWidth',0.3)
    quiver(X_T(1:sp_q_T:end,1:sp_q_T:end),Y_T(1:sp_q_T:end,1:sp_q_T:end),VX_T(1:sp_q_T:end-1,1:sp_q_T:end),VY_T(1:sp_q_T:end,1:sp_q_T:end-1),0.5,'r','LineWidth',0.3)
    axis equal

    %PLOT SETTINGS
    axis equal
    title({'Temperature grid (red) & Kinematic grid (blue)';'with velocity arrows'})
    xlabel('Length [km]'),ylabel('Thickness [km]')
    set(gcf,'position',[781 231 792.8000 545.6000])
    hold off
    
%     stringg = ['print -dsvg Grids','.svg -r300'];eval(stringg);
    
end
